/***************************************************************************
 *
 * Copyright (c) 2014 Codethink Limited
 *
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ****************************************************************************/

#ifndef _CALIBRATIONAPPLYPARAMETERSCOMMAND_H_
#define _CALIBRATIONAPPLYPARAMETERSCOMMAND_H_

#include "ICommand.h"

class CalibrationApplyParametersCommand: public ICommand
{
public:
    /*!
     * \action    This command sets the calibration parameters for a given
     *            input device
     * \frequency
     * \param[in] sender     Process id fo the application that sent this
     *                       command
     * \param[in] deviceName Name of the input device
     * \param[in] x1         The first X parameter
     * \param[in] x2         The second X parameter
     * \param[in] x3         The third X parameter
     * \param[in] y1         The first Y parameter
     * \param[in] y2         The second Y parameter
     * \param[in] y3         The third Y parameter
     * \ingroup   Commands
     */
    CalibrationApplyParametersCommand(pid_t sender,
                                    const std::string& deviceName,
                                    float x1, float x2, float x3,
                                    float y1, float y2, float y3)
    : ICommand(ExecuteSynchronous, sender)
    , m_deviceName(deviceName)
    , m_x1(x1)
    , m_x2(x2)
    , m_x3(x3)
    , m_y1(y1)
    , m_y2(y2)
    , m_y3(y3)
    {}

    /**
     * \brief default destructor
     */
    virtual ~CalibrationApplyParametersCommand() {}

    /**
     * \brief Execute this command.
     * \param[in] executor Pointer to instance executing the LayerManager
     *                     Commands
     * \return ExecutionSuccess: execution successful
     * \return ExecutionFailed: execution failed
     */
    virtual ExecutionResult execute(ICommandExecutor* executor);

    /**
     * \brief Get description string for this command.
     * \return String object with description of this command object
     */
    virtual const std::string getString();

private:
    const std::string& m_deviceName;
    float m_x1;
    float m_x2;
    float m_x3;
    float m_y1;
    float m_y2;
    float m_y3;
};

#endif // _CALIBRATIONAPPLYPARAMETERSCOMMAND_H_
